@extends('layouts.app')

@section('title', 'Home')

@php
$curPlyers = 0;
foreach($servers as $srv) {
    $curPlyers = $curPlyers + $srv->current_players;
}
@endphp

@section('content')
    <div class="hero-section">
        <div class="container">
            <div class="hero-content">
                <h1>{{ config_value('site_name', 'Welcome!') }}</h1>
                <p>{{ config_value('tag_line', 'Your best place for gaming.') }}</p>
                <div class="hero-buttons">
                </div>
            </div>
            <div class="server-stats">
                <div class="stat-item">
                    <span class="stat-value">{{ $curPlyers }}</span>
                    <span class="stat-label">Players Online</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value">{{ \App\Models\User::count() }}</span>
                    <span class="stat-label">Registered Users</span>
                </div>
                <div class="stat-item">
                    <span class="stat-value">{{ \App\Models\Server::count() }}</span>
                    <span class="stat-label">Active Servers</span>
                </div>
            </div>
        </div>
    </div>

    <section class="features-section">
        <div class="container">
            <h2 class="section-title">Why Choose {{ config_value('site_name', 'Our Community') }}?</h2>
            <div class="features-grid">
                @for ($i = 1; $i <= 4; $i++)
                    @if (config_value("home_box_{$i}_enabled", false))
                        <div class="feature-card">
                            <div class="feature-icon">
                                <i class="fas fa-{{ config_value("home_box_{$i}_fa_icon", 'star') }} fa-2x"></i>
                            </div>
                            <h3>{{ config_value("home_box_{$i}_title", "Feature Title {$i}") }}</h3>
                            <p>{{ config_value("home_box_{$i}_text", "Feature description for box {$i}.") }}</p>
                        </div>
                    @endif
                @endfor
            </div>
        </div>
    </section>

    @php
        $gamemodes = [
            'darkrp' => 'DarkRP',
            'deathrun' => 'Deathrun',
            'ttt' => 'Trouble in Terrorist Town',
            'scprp' => 'SCP RP',
            'murder' => 'Murder',
            'prophunt' => 'Prop Hunt',
        ];

        function formatGamemode($gamemodeString, $gamemodes) {
            if (preg_match('/gm:([^\s]+)/', $gamemodeString, $matches)) {
                $gamemodeKey = strtolower($matches[1]);
                return $gamemodes[$gamemodeKey] ?? ucfirst($gamemodeKey);
            }
            return $gamemodeString;
        }
    @endphp

    @if (config_value('servers_enabled', false))
        <section class="servers-section" id="servers">
            <div class="container">
                <h2 class="section-title">Our Servers</h2>
                <div class="servers-grid">
                    @forelse($servers as $server)
                        <div class="server-card">
                            <div class="server-header">
                                <h3>{{ $server->name }}</h3>
                                <span class="server-status {{ $server->status }}">{{ ucfirst($server->status) }}</span>
                            </div>
                            <div class="server-info">
                                <div class="info-item">
                                    <span class="info-label">Players:</span>
                                    <span class="info-value">{{ $server->current_players }}/{{ $server->max_players }}</span>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Map:</span>
                                    <span class="info-value">{{ $server->current_map }}</span>
                                </div>
                                <div class="info-item">
                                    <span class="info-label">Gamemode:</span>
                                    <span class="info-value">{{ formatGamemode($server->gamemode, $gamemodes) }}</span>
                                </div>
                            </div>
                            <a href="{{ $server->connect_url }}" class="btn btn-primary btn-block">Connect Now</a>
                        </div>
                    @empty
                        <div class="no-servers">
                            <p>No servers are currently available.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </section>
    @endif


    @if (config_value('toggle_news') === true && config_value('news_enabled') === true && count($latestNews) > 0)
        <section class="news-section">
            <div class="container">
                <h2 class="section-title">Latest News</h2>
                <div class="news-grid">
                    @foreach($latestNews as $news)
                    <div class="news-card">
                        <div class="news-image">
                            <img src="{{ asset('storage/' . $news->image) }}" alt="News 1">
                        </div>
                        <div class="news-content">
                            <span class="news-date">{{ $news->created_at->format('F d, Y') }}</span>
                            <h3>{{ $news->title }}</h3>
                            <p>{{ $news->short_description }}</p>
                            <a href="{{ route('news.show', $news->slug) }}" class="read-more">Read More</a>
                        </div>
                    </div>
                    @endforeach
                </div>
                <div class="view-all-news">
                    <a href="{{ route('news.index') }}" class="btn btn-secondary">View All News</a>
                </div>
            </div>
        </section>
    @endif

    @if (config_value('home_call_to_action_enabled', false))
        <section class="cta-section">
            <div class="container">
                <div class="cta-content">
                    <h2>{{ config_value('home_call_to_action_title', 'Join Us Today!') }}</h2>
                    <p>{{ config_value('home_call_to_action_text', 'Start your journey now and join our awesome community!') }}</p>
                </div>
            </div>
        </section>
    @endif
@endsection
